#include <iostream>
#include <vector>
#include <set>

int brojiLomove(const std::vector<int>& karte, int i) {
    if(i < 0 || i >= (int)karte.size() - 1) {
        return 0;
    }
    return karte[i] > karte[i + 1];
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(0), std::cout.tie(0);

    int brkarata, brupita;
    std::cin >> brkarata >> brupita;

    std::vector<int> karte(brkarata);
    for(int i = 0; i < brkarata; ++i) {
        std::cin >> karte[i];
    }

    int cena = 0;
    for(int i = 0; i < brkarata - 1; ++i) {
        cena += (karte[i] > karte[i + 1]);
    }

    std::cout << cena << std::endl;

    while (brupita--) {
        int i, j;
        std::cin >> i >> j;
        --i; --j;

        if (i > 0) cena -= brojiLomove(karte, i - 1);
        cena -= brojiLomove(karte, i);
        if (j < brkarata - 1) cena -= brojiLomove(karte, j);

        std::swap(karte[i], karte[j]);

        if (i > 0) cena += brojiLomove(karte, i - 1);
        cena += brojiLomove(karte, i);
        if (j < brkarata - 1) cena += brojiLomove(karte, j);

        std::cout << cena << std::endl;
    }

    return 0;
}